<?php

namespace FactelBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityRepository;

class EstablecimientoType extends AbstractType {

    private $securityContext;

    public function __construct($securityContext) {
        $this->securityContext = $securityContext;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
                $builder->add('activo')
                ->add('transporte');
    	$builder
                ->add('nombre',null , array(
                	'label'=>'Nombre',
                    'attr' => array('onkeyup' => 'javascript:this.value=this.value.toUpperCase();')))
                ->add('codigo',null , array(
                	'label'=>'Código',
                    'attr' => array('maxlength' => '3','oninput' => 'this.value = this.value.replace(/[^0-9.]/g, ""); this.value = this.value.replace(/(\..*)\./g, "$1");')))
                ->add('nombreComercial',null , array(
                	'label'=>'Nombre Comercial',
                    'attr' => array('onkeyup' => 'javascript:this.value=this.value.toUpperCase();')))
                ->add('direccion',null , array(
                	'label'=>'Dirección',
                    'attr' => array('onkeyup' => 'javascript:this.value=this.value.toUpperCase();')));
                
        if ($this->securityContext->isGranted("ROLE_ADMIN")) {
            $builder->add('emisor');
        } else {
            $builder->add('emisor', 'entity', array(
                'class' => 'FactelBundle:Emisor',
                'label' => 'Emisor',
                'required' => true,
                'property' => 'razonSocial',
                'query_builder' => function (EntityRepository $repo) {
            		return $repo->createQueryBuilder('e')
                            ->select('emisor')
                            ->from('FactelBundle:Emisor', 'emisor')
                            ->join('emisor.usuarios', 'users')
                            ->andWhere('users.id = :userId')
                            ->setParameter("userId", $this->securityContext->gettoken()->getuser()->getId());
            		})
        		);
        }
        $builder->add('numeroPlaca',null, array(
            'label'=>'Placa',
            'label_attr' => array('id' => 'numeroPlaca_label')
        ));
    
    	
        /*
        $builder->add('logo', 'file', array(
            'data_class' => 'Symfony\Component\HttpFoundation\File\File',
            'property_path' => 'logo',
            'required' => false
        ));
        */
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'FactelBundle\Entity\Establecimiento'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'factelbundle_establecimiento';
    }

}
