<?php

namespace FactelBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ClienteType extends AbstractType {

    private $securityContext;

    public function __construct($securityContext) {
        $this->securityContext = $securityContext;
    }
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                
                
                ->add('tipoIdentificacion', 'choice', array(
                     'placeholder' => 'Seleccionar una opción',
                    'choices' => array(
                        '04' => 'RUC', 
                        '05' => 'CEDULA',
                        '06' => 'PASAPORTE',
                        '07' => 'CONSUMIDOR FINAL',
                        '08' => 'IDENTIFICACION DEL EXTERIOR',
                        '09' => 'PLACA',
                        ),
                    'required' => true,
                ))
                ->add('identificacion','text',array(
                    'attr' => array('maxlength' => '20','oninput' => 'this.value = this.value.replace(/[^0-9.]/g, ""); this.value = this.value.replace(/(\..*)\./g, "$1");')
                ))
                ->add('nombre','text',array('attr' => array('onkeyup' => 'javascript:this.value=this.value.toUpperCase();')))
                ->add('celular','text',array('attr' => array('maxlength' => '20','oninput' => 'this.value = this.value.replace(/[^0-9.]/g, ""); this.value = this.value.replace(/(\..*)\./g, "$1");')))
                ->add('correoElectronico', 'email', [
                    'label' => 'Correo Electrónico',
                    'required' => false,
                    'attr' => array('onChange' => 'validarEmail()')
                ])
                ->add('direccion')
        ;
        if ($this->securityContext->isGranted("ROLE_ADMIN")) {
            $builder->add('emisor');
        }
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'FactelBundle\Entity\Cliente'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'factelbundle_cliente';
    }

}
