<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * RetencionRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class RetencionRepository extends EntityRepository {

    public function findRetencionById($id) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("retencion, emisor, establecimiento, ptoEmision, impuestos, cliente")
                ->from("FactelBundle:Retencion", "retencion")
                ->join("retencion.emisor", "emisor")
                ->join("retencion.establecimiento", "establecimiento")
                ->join("retencion.cliente", "cliente")
                ->join("retencion.ptoEmision", "ptoEmision")
                ->join("retencion.impuestos", "impuestos")
                ->where('retencion.id = :id')
                ->setParameter('id', $id);

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function cantidadRetenciones($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(retencion.id)")
                ->from("FactelBundle:Retencion", "retencion");
        if ($idEmisor == null) {
            $qb->join("retencion.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("retencion.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }


    public function cantidadRetencionesC($idPtoEmision, $idEmisor,$fechaInicial,$fechaFinal) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(retencion.id)")
                ->from("FactelBundle:Retencion", "retencion");
        if ($idEmisor == null) {
            $qb->join("retencion.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("retencion.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
     $qb->andWhere('retencion.estado = :estadoLiquidacion');
            $qb->setParameter("estadoLiquidacion", "AUTORIZADO");
        $qb->andWhere("retencion.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }

    public function cantidadRetencionesEstados($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("retencion.estado,COUNT(retencion.estado) as cantidad")
                ->from("FactelBundle:Retencion", "retencion");
        if ($idEmisor == null) {
            $qb->join("retencion.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("retencion.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

        $qb->groupBy("retencion.estado");
        return $qb->getQuery()->getResult();
    }

    public function findRetenciones($search, $start, $limit, $idPtoEmision, $idEmisor) {
        $datos = explode("&", $search);
        $fechaInicial = "";
        $fechaFinal = "";
        if (count($datos) == 3) {
            $search = $datos[2];
            $fechaInicial = $datos[0];
            $fechaFinal = $datos[1];
        }
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("retencion, estab, ptoEmision, cliente")
                ->from("FactelBundle:Retencion", "retencion")
                ->join("retencion.emisor", "emisor")
                ->join("retencion.establecimiento", "estab")
                ->join("retencion.ptoEmision", "ptoEmision")
                ->join("retencion.cliente", "cliente");
        $qb->setMaxResults($limit);
        $qb->setFirstResult($start);
        if ($search != "") {
            $qb->where(
                            $qb->expr()->like('retencion.estado', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('retencion.claveAcceso', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('retencion.secuencial', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('retencion.periodoFiscal', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.nombre', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('retencion.numeroAutorizacion', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.identificacion', $qb->expr()->literal('%' . $search . '%'))
            );
        }
        if ($idEmisor == null) {
            $qb->andWhere('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->andWhere('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
        if ($fechaInicial != "" && $fechaFinal) {
            $qb->andWhere("retencion.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        }
        $qb->orderBy("retencion.secuencial", "DESC");
        return $qb->getQuery()->getResult();
    }

    public function totalRetencionesQB($search, $start, $limit, $idEmisor, $incluirNumFactura = false) {
        $datos = explode("&", $search);
        $fechaInicial = "";
        $fechaFinal = "";
        if (count($datos) == 3) {
            $search = $datos[2];
            $fechaInicial = $datos[0];
            $fechaFinal = $datos[1];
        }
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
    

    
        if ($incluirNumFactura)
            $qb->select("impuestoRetencion.codigo as tipoRetencion,impuestoRetencion.codigoRetencion as codigo,sum(impuestoRetencion.baseImponible) as totalBaseImponible, "
                    . "sum(impuestoRetencion.valorRetenido) as totalRetenido, impuestoRetencion.numDocSustento as factura");
        else
            $qb->select("impuestoRetencion.codigo as tipoRetencion,impuestoRetencion.codigoRetencion as codigo,sum(impuestoRetencion.baseImponible) as totalBaseImponible, "
                    . "sum(impuestoRetencion.valorRetenido) as totalRetenido");
        $qb->from("FactelBundle:ImpuestoComprobanteRetencion", "impuestoRetencion")
                ->join("impuestoRetencion.retencion", "retencion")
                ->join("retencion.emisor", "emisor");
        $qb->setMaxResults($limit);
        $qb->setFirstResult($start);
        if ($search != "" && !$incluirNumFactura) {
            $qb->Where('impuestoRetencion.codigoRetencion = :codigoRetencion');
            $qb->setParameter("codigoRetencion", $search);
        }
        if ($search != "" && $incluirNumFactura) {
            $qb->where(
                            $qb->expr()->like('impuestoRetencion.codigoRetencion', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('impuestoRetencion.numDocSustento', $qb->expr()->literal('%' . $search . '%'))
            );
        }

        $qb->andWhere('emisor.id = :idEmisor');
        $qb->setParameter("idEmisor", $idEmisor);

        if ($fechaInicial != "" && $fechaFinal) {
            $qb->andWhere("retencion.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        }
        $qb->orderBy("impuestoRetencion.codigo, impuestoRetencion.codigoRetencion", "ASC");
        return   $qb;
    }

public function Group_disable() {

		$emE = $this->getEntityManager();
        $qbE = $emE->createQueryBuilder();
    	$qbE->select("SET sql_mode='NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION'");
	
		$arch = fopen("sql_mode.txt", "a+"); 
		fwrite($arch,$qbE."\r\n");
		fclose($arch);

        $qbE->getQuery()->getResult();
}

    public function totalRetencionesPorCodigo($search, $start, $limit, $idEmisor) {
    	
    	
    //	$a = $this->Group_disable();
    
        $qb = $this->totalRetencionesQB($search, $start, $limit, $idEmisor);
        $qb->groupBy("impuestoRetencion.codigoRetencion");
        return $qb->getQuery()->getResult();
    }

    public function totalRetencionesPorFactura($search, $start, $limit, $idEmisor) {
        $qb = $this->totalRetencionesQB($search, $start, $limit, $idEmisor, true);

        $qb->groupBy("impuestoRetencion.codigoRetencion,impuestoRetencion.numDocSustento");
        return $qb->getQuery()->getResult();
    }

}
