<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * NotaDebitoRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class NotaDebitoRepository extends EntityRepository {

    public function cantidadNotasDebito($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(notaDebito.id)")
                ->from("FactelBundle:NotaDebito", "notaDebito");
        if ($idEmisor == null) {
            $qb->join("notaDebito.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("notaDebito.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }

    public function cantidadNotasDebitoC($idPtoEmision, $idEmisor,$fechaInicial,$fechaFinal) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(notaDebito.id)")
                ->from("FactelBundle:NotaDebito", "notaDebito");
        if ($idEmisor == null) {
            $qb->join("notaDebito.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("notaDebito.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
  $qb->andWhere('notaDebito.estado = :estadoLiquidacion');
            $qb->setParameter("estadoLiquidacion", "AUTORIZADO");
        $qb->andWhere("notaDebito.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }

    public function cantidadNotasDebitoEstados($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("notaDebito.estado,COUNT(notaDebito.estado) as cantidad")
                ->from("FactelBundle:NotaDebito", "notaDebito");
        if ($idEmisor == null) {
            $qb->join("notaDebito.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("notaDebito.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

       $qb->groupBy("notaDebito.estado");
        return $qb->getQuery()->getResult();
    }
    
    public function findNotaDebitoById($id) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("notaDebito, emisor, establecimiento, ptoEmision, impuestos, cliente, motivos")
                ->from("FactelBundle:NotaDebito", "notaDebito")
                ->join("notaDebito.emisor", "emisor")
                ->join("notaDebito.establecimiento", "establecimiento")
                ->join("notaDebito.cliente", "cliente")
                ->join("notaDebito.ptoEmision", "ptoEmision")
                ->join("notaDebito.motivos", "motivos")
                ->join("notaDebito.impuestos", "impuestos")
                ->where('notaDebito.id = :id')
                ->setParameter('id', $id);

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findNotasDebito($search, $start, $limit, $idPtoEmision, $idEmisor) {
         $datos = explode("&", $search);
        $fechaInicial = "";
        $fechaFinal = "";
        if (count($datos) == 3) {
            $search = $datos[2];
            $fechaInicial = $datos[0];
            $fechaFinal = $datos[1];
        }
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("notaDebito, estab, ptoEmision, cliente")
                ->from("FactelBundle:NotaDebito", "notaDebito")
                ->join("notaDebito.emisor", "emisor")
                ->join("notaDebito.establecimiento", "estab")
                ->join("notaDebito.ptoEmision", "ptoEmision")
                ->join("notaDebito.cliente", "cliente");
        $qb->setMaxResults($limit);
        $qb->setFirstResult($start);
        if ($search != "") {
            $qb->where(
                            $qb->expr()->like('notaDebito.estado', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('notaDebito.claveAcceso', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('notaDebito.secuencial', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.nombre', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('notaDebito.numeroAutorizacion', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.identificacion', $qb->expr()->literal('%' . $search . '%'))
            );
            if (strtotime($search)) {
                $search = str_replace("/", "-", $search);
                $qb->orWhere('notaDebito.fechaEmision = :fecha');
                $qb->setParameter("fecha", new \DateTime($search));
            }
        }
        if ($idEmisor == null) {
            $qb->andWhere('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->andWhere('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
        if ($fechaInicial != "" && $fechaFinal) {
            $qb->andWhere("notaDebito.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        }
        $qb->orderBy("notaDebito.secuencial", "DESC");
        return $qb->getQuery()->getResult();
    }

}
