<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * NotaCreditoRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class NotaCreditoRepository extends EntityRepository {

    public function findNotaCreditoById($id) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("notaCredito, emisor, establecimiento, ptoEmision, notaCreditoHasProducto, producto, impuestos, cliente")
                ->from("FactelBundle:NotaCredito", "notaCredito")
                ->join("notaCredito.emisor", "emisor")
                ->join("notaCredito.establecimiento", "establecimiento")
                ->join("notaCredito.cliente", "cliente")
                ->join("notaCredito.ptoEmision", "ptoEmision")
                ->join("notaCredito.notaCreditoHasProducto", "notaCreditoHasProducto")
                ->join("notaCreditoHasProducto.producto", "producto")
                ->join("notaCreditoHasProducto.impuestos", "impuestos")
                ->where('notaCredito.id = :id')
                ->setParameter('id', $id);

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function cantidadNotasCredito($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(notaCredito.id)")
                ->from("FactelBundle:NotaCredito", "notaCredito");

        if ($idEmisor == null) {
            $qb->join("notaCredito.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("notaCredito.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }
    

    public function cantidadNotasCreditoC($idPtoEmision, $idEmisor,$fechaInicial,$fechaFinal) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(notaCredito.id)")
                ->from("FactelBundle:NotaCredito", "notaCredito");

        if ($idEmisor == null) {
            $qb->join("notaCredito.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("notaCredito.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
    
     $qb->andWhere('notaCredito.estado = :estadoLiquidacion');
            $qb->setParameter("estadoLiquidacion", "AUTORIZADO");

        $qb->andWhere("notaCredito.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);

        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }

    public function cantidadNotasCreditoEstados($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("notaCredito.estado,COUNT(notaCredito.estado) as cantidad")
                ->from("FactelBundle:NotaCredito", "notaCredito");

        if ($idEmisor == null) {
            $qb->join("notaCredito.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("notaCredito.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

        $qb->groupBy("notaCredito.estado");
        return $qb->getQuery()->getResult();
    }

    public function findNotasCredito($search, $start, $limit, $idPtoEmision, $idEmisor) {
        $datos = explode("&", $search);
        $fechaInicial = "";
        $fechaFinal = "";
        if (count($datos) == 3) {
            $search = $datos[2];
            $fechaInicial = $datos[0];
            $fechaFinal = $datos[1];
        }

        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("notaCredito, estab, ptoEmision, cliente")
                ->from("FactelBundle:NotaCredito", "notaCredito")
                ->join("notaCredito.emisor", "emisor")
                ->join("notaCredito.establecimiento", "estab")
                ->join("notaCredito.ptoEmision", "ptoEmision")
                ->join("notaCredito.cliente", "cliente");
        $qb->setMaxResults($limit);
        $qb->setFirstResult($start);
        if ($search != "") {
            $qb->where(
                            $qb->expr()->like('notaCredito.estado', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('notaCredito.claveAcceso', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('notaCredito.secuencial', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.nombre', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('notaCredito.numeroAutorizacion', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.identificacion', $qb->expr()->literal('%' . $search . '%'))
            );
            if (strtotime($search)) {
                $search = str_replace("/", "-", $search);
                $qb->orWhere('notaCredito.fechaEmision = :fecha');
                $qb->setParameter("fecha", new \DateTime($search));
            }
        }
        if ($idEmisor == null) {
            $qb->andWhere('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->andWhere('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
        if ($fechaInicial != "" && $fechaFinal) {
            $qb->andWhere("notaCredito.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        }
        $qb->orderBy("notaCredito.secuencial", "DESC");
        return $qb->getQuery()->getResult();
    }

}
