<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * ClienteRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ClienteRepository extends EntityRepository {

    public function cantidadClientes($emisorId) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(cliente.id)")
                ->from("FactelBundle:Cliente", "cliente")
                ->join("cliente.emisor", "emisor")
                ->where("emisor.id = :emisorId");
        $qb->setParameter("emisorId", $emisorId);

        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }

    public function findClientes($search, $start, $limit, $emisorId) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("cliente")
                ->from("FactelBundle:Cliente", "cliente")
                ->join("cliente.emisor", "emisor")
                ->where("emisor.id = :emisorId");
        $qb->setParameter("emisorId", $emisorId);
        $qb->setMaxResults($limit);
        $qb->setFirstResult($start);
        if ($search != "") {
            $qb->andWhere(
                            $qb->expr()->like('cliente.nombre', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.identificacion', $qb->expr()->literal('%' . $search . '%'))
            );
        }
        return $qb->getQuery()->getResult();
    }


    public function findClienteIdFinal($emisorId, $identificacion) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("cliente")
                ->from("FactelBundle:Cliente", "cliente")
                ->join("cliente.emisor", "emisor")
                ->where("emisor.id = :emisorId");
        $qb->setParameter("emisorId", $emisorId);
        $qb->andWhere(
                        $qb->expr()->like('cliente.identificacion', $qb->expr()->literal('%' . $identificacion . '%'))
                    );
        
        return $qb->getQuery()->getResult();
    }

}
