<?php

namespace FactelBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use FactelBundle\Entity\Emisor;
use FactelBundle\Form\EmisorType;
use JMS\SecurityExtraBundle\Annotation\Secure;

/**
 * Emisor controller.
 *
 * @Route("/emisor")
 */
class EmisorController extends Controller {

    /**
     * Lists all Emisor entities.
     *
     * @Route("/", name="emisor")
     * @Method("GET")
     * @Template()
     */
   public function indexAction() {

        if ($this->get("security.context")->isGranted("ROLE_ADMIN")) {
            $em = $this->getDoctrine()->getManager();
            $planes = $em->getRepository('FactelBundle:Plan')->findBy(array("activo" => true));
            $entities = $em->getRepository('FactelBundle:Emisor')->findAll();
            $deleteForms = array();
            $deleteFormsT = array();
            $count = array();
            $conteo_empreas=0;
            foreach ($entities as $entity) {

                $archivoP12 = $entity->getDirFirma();
                $clave = $entity->getPassFirma();

                $deleteForms[$entity->getId()] = $this->createDeleteForm($entity->getId())->createView();
                $conteoF = $em->getRepository('FactelBundle:Factura')->cantidadFacturasC('', $entity->getId(),$entity->getFechaInicio(),$entity->getFechaFin());
                $conteoL = $em->getRepository('FactelBundle:LiquidacionCompra')->cantidadLiquidacionesC('', $entity->getId(),$entity->getFechaInicio(),$entity->getFechaFin());
                $conteoC = $em->getRepository('FactelBundle:NotaCredito')->cantidadNotasCreditoC('', $entity->getId(),$entity->getFechaInicio(),$entity->getFechaFin());
                $conteoD = $em->getRepository('FactelBundle:NotaDebito')->cantidadNotasDebitoC('', $entity->getId(),$entity->getFechaInicio(),$entity->getFechaFin());
                $conteoR = $em->getRepository('FactelBundle:Retencion')->cantidadRetencionesC('', $entity->getId(),$entity->getFechaInicio(),$entity->getFechaFin());
                $conteoG = $em->getRepository('FactelBundle:Guia')->cantidadGuiasC('', $entity->getId(),$entity->getFechaInicio(),$entity->getFechaFin());
                $conteo  = $conteoF + $conteoL + $conteoC + $conteoD + $conteoR + $conteoG;
                $deleteFormsT[$entity->getId()] = $conteo;



            if($archivoP12 == 'SN') {
				$fechaExpiracion = '0000-00-00';
                $fechaExpiracions = '0000-00-00';
            }
            else
             {
                // Intentar abrir el archivo P12
                $certificado = file_get_contents($archivoP12);
                
                // Intentar cargar el certificado P12
                if (!openssl_pkcs12_read($certificado, $certs, $clave)) {
                    $fechaExpiracion = '0000-00-00';
                    $fechaExpiracions = '0000-00-00';
                }
                else
                {
                    // Extraer la información de validez del certificado
                    $certData = openssl_x509_parse($certs['cert']);
                    $fechaInicio = date('Y-m-d H:i:s', $certData['validFrom_time_t']);
                    $fechaExpiracion = date('Y-m-d', $certData['validTo_time_t']);
                    $fecha1 = date('Y-m-d'); // Primera fecha en formato YYYY-MM-DD
                    $fecha2 = $fechaExpiracion; // Segunda fecha en formato YYYY-MM-DD
                    

                    $fecha1c = new \DateTime($fecha1);
                    $fecha2c = new \DateTime($fecha2);

   
                    $diferencia = $fecha1c->diff($fecha2c);
                     $diferenciaDias = $diferencia->format('%R%a');
                    /*
                    $timestamp1 = strtotime($fecha1);
                    $timestamp2 = strtotime($fecha2);
                    $diferenciaSegundos = abs($timestamp2 - $timestamp1);
                    $diferenciaDias = floor($diferenciaSegundos / (60 * 60 * 24));
                    */
                    if($diferenciaDias <= 7)
                    {
                        $conteo_empreas++;
                    }
                    $fechaExpiracions = $diferenciaDias;
                }
               }  
                

                    $plan = $em->getRepository('FactelBundle:Plan')->findById($entity->getPlan()->getId());
                    foreach ($plan as $plan)
                    {
                        $getCantComprobante =   $plan->getCantComprobante();
                        $plan = ''.$plan->getObservaciones().' - '.$plan->getCantComprobante();
                        
                    }
               
                $deleteFormsP[$entity->getId()] = $plan;


                $deleteFormsVi[$entity->getId()] = $fechaExpiracion;
                $deleteFormsCo[$entity->getId()] = $fechaExpiracions;
                $deleteFormsEmp[$entity->getId()] = $conteo_empreas;
                $deleteFormsTotalPlan[$entity->getId()] = $getCantComprobante;

            }

          
            return array(
                'entities' => $entities,
                'deleteForms' => $deleteForms,
                'planes' => $planes,
                'deleteFormsT' => $deleteFormsT,
                'deleteFormsP' => $deleteFormsP,
                'deleteFormsVi' => $deleteFormsVi,
                'deleteFormsCo' => $deleteFormsCo,
                'deleteFormsEmp' => $deleteFormsEmp,
                'deleteFormsTotalPlan' => $deleteFormsTotalPlan
            );
        } else {
            $user = $this->get("security.context")->getToken()->getUser();
            return $this->render(
                            'FactelBundle:Emisor:show.html.twig', array('entity' => $user->getEmisor())
            );
        }
    }

    /**
     * Creates a new Emisor entity.
     *
     * @Route("/", name="emisor_create")
     * @Secure(roles="ROLE_ADMIN")
     * @Method("POST")
     * @Template("FactelBundle:Emisor:new.html.twig")
     */

    public function createAction(Request $request) {
        $em = $this->getDoctrine()->getManager();
        $entity = new Emisor();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid()) {
            
            $ruc = $form['ruc']->getData();
            $direccion = $form['direccionMatriz']->getData();
            $result = $em->getRepository('FactelBundle:Emisor')->findByRuc($ruc);
            if($result)
            {
               echo '<script>alert("Error : ruc registrado!");</script>';
            }
            else
            {
                $newLogo = $form['logo']->getData();
                $newFirma = $form['firma']->getData();

                

                    $fullDirArchivo = '/home/demo/'.$form['ruc']->getData();
                    //$fullDirArchivo = 'C:\Users\USER\Documents\FACTURADOR_LITE/'.$form['ruc']->getData();
                    
                    if (!is_dir($fullDirArchivo)) {
                        mkdir($fullDirArchivo, 0777, true);
                    }
                    $dirAutorizado = $fullDirArchivo;
                    if (!is_dir($dirAutorizado)) {
                        mkdir($dirAutorizado, 0777, true);
                    }
                    $entity->setDirDocAutorizados($dirAutorizado);
                    $planId = $em->getRepository('FactelBundle:Plan')->find(1);
                    $entity->setPlan($planId);
                    $fechaInicio  = date('Y-m-d');
                    $fechaInicio = new \DateTime($fechaInicio);
                    $fechaFin     = date("Y-m-d",strtotime(date('Y-m-d')."+ 5 days"));
                    $fechaFin = new \DateTime($fechaFin);
                    $entity->setFechaInicio($fechaInicio);
                    $entity->setFechaFin($fechaFin);
                    $entity->setSSL(1);
                    


                    /** SI EXISTE LOGO **/
                    if($form['logo']->getData() !='')
                    {
                        $newLogo = $form['logo']->getData();
                        $newLogo->move($fullDirArchivo, $newLogo->getClientOriginalName());
                        $entity->setDirLogo($fullDirArchivo . "/" . $newLogo->getClientOriginalName());
                    }
                    else
                    {
                        copy('/home/demo/img/sin_logo.png',$fullDirArchivo.'/sin_logo.png');
                        $entity->setDirLogo($fullDirArchivo . "/" . 'sin_logo.png');
                    }


                    /** SI EXISTE FIRMA **/
                    $pasador = 0;
                    if($form['firma']->getData() == '')
                    {
                        $Firma = "NA";
                        $entity->setDirFirma("SN");
                        $pasador = 1;

                        
                    }
                    else
                    {
                        
                        $newFirma->move($fullDirArchivo, $newFirma->getClientOriginalName());
                        $entity->setDirFirma($fullDirArchivo . "/" . $newFirma->getClientOriginalName());


                        $path_parts = pathinfo($newFirma->getClientOriginalName());
                        if (($path_parts['extension'] == 'p12' OR $path_parts['extension'] == 'pfx')) 
                        //if (1 == 1) 
                        {
                            $almacen_cert = file_get_contents($fullDirArchivo . "/" . $newFirma->getClientOriginalName());
                            if (openssl_pkcs12_read($almacen_cert, $info_cert, $form['passFirma']->getData())) 
                            //if(1 ==1)
                            {
                                $pasador = 1;
                            }
                            else
                            {
                                echo '<script>alert("Error : clave invalida para firma");</script>';
                                $pasador = 0;
                            }
                        }
                        else
                        {
                            echo '<script>alert("Error : archivo debe ser p12 o pfx");</script>';
                        }
                    }

                    //SI TODO ESTA CORRECTO
                    if($pasador == 1)
                    {

                       
                        
                                $em->persist($entity);
                                $em->flush();

                                /** PARA CREAR ESTABLECIMIENTO **/
                                $establecimiento = new \FactelBundle\Entity\Establecimiento();
                                $emisorId = $entity->getId();
                                $emisor = $em->getRepository('FactelBundle:Emisor')->find($emisorId);
                                $establecimiento->setEmisor($emisor);
                                $establecimiento->setNombre('Matriz');
                                $establecimiento->setCodigo('001');
                                $establecimiento->setNombreComercial('Matriz');
                                $establecimiento->setDireccion($direccion);
                                $establecimiento->setActivo('1');
                                $em->persist($establecimiento);
                                $em->flush();
                                $establecimientoId = $establecimiento->getId();


                                /** PARA CREAR CONSUMIDOR FINAL POR EMPRESA **/
                                $cliente = new \FactelBundle\Entity\Cliente();
                                $emisorId = $entity->getId();
                                $emisor = $em->getRepository('FactelBundle:Emisor')->find($emisorId);
                                $cliente->setEmisor($emisor);
                                $cliente->setNombre('CONSUMIDOR FINAL');
                                $cliente->setTipoIdentificacion('07');
                                $cliente->setIdentificacion('9999999999999');
                                $cliente->setCelular('9999999999');
                                $cliente->setCorreoElectronico('correo@correo.com');
                                $cliente->setDireccion('NA');
                                $em->persist($cliente);
                                $em->flush();

                                /** PARA CREAR USUARIO **/
                                $usuario = new \FactelBundle\Entity\User();
                                $emisor = $em->getRepository('FactelBundle:Emisor')->find($emisorId);
                                $usuario->setEmisor($emisor);
                                $rol = $em->getRepository('FactelBundle:Role')->find(2);
                                $usuario->setRol($rol);
                                $usuario->setUsername($ruc);
                                $usuario->setSalt(md5(time()));
                                $encoder  = new \Symfony\Component\Security\Core\Encoder\MessageDigestPasswordEncoder('sha512', true, 10);
                                $password = $encoder->encodePassword($ruc,md5(time()));
                                $usuario->setPassword($password);
                                $usuario->setEmail('empresa@empresa.com');
                                $usuario->setNombre($ruc);
                                $usuario->setApellidos($ruc);
                                $usuario->setIsActive(1);
                                $usuario->setCopiarEmail(0);
                                $em->persist($usuario);
                                $em->flush();
                                $usuarioId = $usuario->getId();
                                

                                /** PARA CREAR PTOEMISION **/
                                $ptoemision = new \FactelBundle\Entity\PtoEmision();
                                $id_usuario = $em->getRepository('FactelBundle:User')->find($usuarioId);
                                $ptoemision->setUsuario($id_usuario);
                                $establecimiento = $em->getRepository('FactelBundle:Establecimiento')->find($establecimientoId);
                                $ptoemision->setEstablecimiento($establecimiento);
                                $ptoemision->setNombre('Matriz');
                                $ptoemision->setCodigo('010');
                                $ptoemision->setSecuencialFactura('1');
                                $ptoemision->setSecuencialNotaCredito('1');
                                $ptoemision->setSecuencialNotaDebito('1');
                                $ptoemision->setSecuencialGuiaRemision('1');
                                $ptoemision->setSecuencialRetencion('1');
                                $ptoemision->setSecuencialProforma('1');
                                $ptoemision->setSecuencialLiquidacionCompra('1');
                                $ptoemision->setSecuencialCompra('1');
                                $ptoemision->setActivo('1');
                                $em->persist($ptoemision);
                                $em->flush();

                                return $this->redirect($this->generateUrl('emisor'));
                    } 
            }   
        }


        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a new Emisor entity.
     *
     * @Route("/configurar-plan", name="config-plan")
     * @Secure(roles="ROLE_ADMIN")
     * @Method("POST")
     */
    public function configAction(Request $request) {
        $fechaInicio = $request->request->get("fechaInicial");
        $fechaFin = $request->request->get("fechaFinal");
        $idPlan = $request->request->get("plan");
        $idEmisor = $request->request->get("idEmisor");
        $em = $this->getDoctrine()->getManager();
        $emisor = new Emisor();
        $emisor = $em->getRepository('FactelBundle:Emisor')->find($idEmisor);
        $plan = $em->getRepository('FactelBundle:Plan')->find($idPlan);
        $fechaModificada = str_replace("/", "-", $fechaInicio);
        $fecha = new \DateTime($fechaModificada);

        $emisor->setFechaInicio($fecha);
        $fechaModificada = str_replace("/", "-", $fechaFin);
        $fecha = new \DateTime($fechaModificada);
        $emisor->setFechaFin($fecha);
        $emisor->setPlan($plan);
        $emisor->setCantComprobante(0);
        $em->persist($emisor);
        $em->flush();

        $this->get('session')->getFlashBag()->add(
                'confirm', "Se ha configurado el plan " . $plan->getNombre() . " al emisor " . $emisor->getRazonSocial()
        );
        return $this->redirect($this->generateUrl('emisor'));
    }

    /**
     * Creates a form to create a Emisor entity.
     *
     * @param Emisor $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Emisor $entity) {
        $form = $this->createForm(new EmisorType($this->get("security.context")), $entity, array(
            'action' => $this->generateUrl('emisor_create'),
            'method' => 'POST',
            'attr' => array('id' => "create")
        ));


        return $form;
    }

    /**
     * Displays a form to edit an existing Emisor entity.
     *
     * @Route("/borrar-doc-prueba", name="borrar_doc")
     * @Secure(roles="ROLE_EMISOR_ADMIN")
     * @Method("GET")
     */
    public function deleteDocumentoPrueba() {
        $em = $this->getDoctrine()->getManager();
        $emisorId = $em->getRepository('FactelBundle:User')->findEmisorId($this->get("security.context")->gettoken()->getuser()->getId());
        $emisor = new Emisor();
        $emisor = $em->getRepository('FactelBundle:Emisor')->find($emisorId);
        foreach ($emisor->getFacturas() as $factura) {
            if ($factura->getAmbiente() == "1") {
                foreach ($factura->getMensajes() as $mensaje) {
                    $em->remove($mensaje);
                }

                foreach ($factura->getFacturasHasProducto() as $facturaHasProducto) {
                    foreach ($facturaHasProducto->getImpuestos() as $impuesto) {
                        $em->remove($impuesto);
                    }
                    foreach ($facturaHasProducto->getDetallesAdicionales() as $detalle) {
                        $em->remove($detalle);
                    }
                    $em->remove($facturaHasProducto);
                }
                $em->remove($factura);
            }
        }

        foreach ($emisor->getNotasCredito() as $notaCredito) {
            if ($notaCredito->getAmbiente() == "1") {
                foreach ($notaCredito->getMensajes() as $mensaje) {
                    $em->remove($mensaje);
                }

                foreach ($notaCredito->getNotaCreditoHasProducto() as $notaCreditoHasProducto) {
                    foreach ($notaCreditoHasProducto->getImpuestos() as $impuesto) {
                        $em->remove($impuesto);
                    }
                    foreach ($notaCreditoHasProducto->getDetallesAdicionales() as $detalle) {
                        $em->remove($detalle);
                    }
                    $em->remove($notaCreditoHasProducto);
                }
                $em->remove($notaCredito);
            }
        }
        foreach ($emisor->getNotasDebito() as $notaDebito) {
            if ($notaDebito->getAmbiente() == "1") {
                foreach ($notaDebito->getMensajes() as $mensaje) {
                    $em->remove($mensaje);
                }

                foreach ($notaDebito->getMotivos() as $motivo) {
                    $em->remove($motivo);
                }
                foreach ($notaDebito->getImpuestos() as $impuesto) {
                    $em->remove($impuesto);
                }
                $em->remove($notaDebito);
            }
        }

        foreach ($emisor->getRetencion() as $retencion) {
            if ($retencion->getAmbiente() == "1") {
                foreach ($retencion->getMensajes() as $mensaje) {
                    $em->remove($mensaje);
                }

                foreach ($retencion->getImpuestos() as $impuestos) {
                    $em->remove($impuestos);
                }
                $em->remove($retencion);
            }
        }

        foreach ($emisor->getGuias() as $guia) {
            if ($guia->getAmbiente() == "1") {
                foreach ($guia->getMensajes() as $mensaje) {
                    $em->remove($mensaje);
                }

                foreach ($guia->getGuiasHasProducto() as $guiaHasProducto) {
                    $em->remove($guiaHasProducto);
                }
                $em->remove($guia);
            }
        }
        
        foreach ($emisor->getLiquidacionesCompra() as $liquidacion) {
            if ($liquidacion->getAmbiente() == "1") {
                foreach ($liquidacion->getMensajes() as $mensaje) {
                    $em->remove($mensaje);
                }
                foreach ($liquidacion->getLiquidacionesCompraHasProducto() as $liquidacionCompraHasProducto) {
                     foreach ($liquidacionCompraHasProducto->getImpuestos() as $impuesto) {
                        $em->remove($impuesto);
                    }
                    $em->remove($liquidacionCompraHasProducto);
                }
                $em->remove($liquidacion);
            }
        }
        $em->flush();
        return $this->redirect($this->generateUrl('home'));
    }

    /**
     * Displays a form to create a new Emisor entity.
     *
     * @Route("/nuevo", name="emisor_new")
     * @Secure(roles="ROLE_ADMIN")
     * @Method("GET")
     * @Template()
     */
    public function newAction() {
        $entity = new Emisor();
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Finds and displays a Emisor entity.
     *
     * @Route("/{id}", name="emisor_show")
     * @Method("GET")
     * @Template()
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('FactelBundle:Emisor')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Emisor entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity' => $entity,
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Displays a form to edit an existing Emisor entity.
     *
     * @Route("/{id}/editar", name="emisor_edit")
     * @Secure(roles="ROLE_ADMIN, ROLE_EMISOR_ADMIN")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('FactelBundle:Emisor')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Emisor entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Creates a form to edit a Emisor entity.
     *
     * @param Emisor $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Emisor $entity) {
        $form = $this->createForm(new EmisorType($this->get("security.context")), $entity, array(
            'action' => $this->generateUrl('emisor_update', array('id' => $entity->getId())),
            'method' => 'PUT',
            'attr' => array('id' => "update")
        ));

        return $form;
    }

    /**
     * Edits an existing Emisor entity.
     *
     * @Route("/{id}", name="emisor_update")
     * @Method("PUT")
     * @Secure(roles="ROLE_ADMIN, ROLE_EMISOR_ADMIN")
     * @Template("FactelBundle:Emisor:edit.html.twig")
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('FactelBundle:Emisor')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Emisor entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            if (isset($editForm['dirDocAutorizados'])) {
                $fullDirArchivo = $editForm['dirDocAutorizados']->getData();
                if (!is_dir($fullDirArchivo)) {
                    mkdir($fullDirArchivo, 0777, true);
                }
            } else {
                $fullDirArchivo = $entity->getDirDocAutorizados();
            }
            $dirAutorizado = $fullDirArchivo;
            $entity->setDirDocAutorizados($dirAutorizado);
            
            if($editForm['logo']->getData() !='')
            {
                $newLogo = $editForm['logo']->getData();
                $newLogo->move($fullDirArchivo, $newLogo->getClientOriginalName());
                $entity->setDirLogo($fullDirArchivo . "/" . $newLogo->getClientOriginalName());
            }

            if($editForm['firma']->getData() !='')
            {
                $newFirma = $editForm['firma']->getData();
                $path_parts = pathinfo($newFirma->getClientOriginalName());
				if (($path_parts['extension'] == 'p12' OR $path_parts['extension'] == 'pfx')) 
				{
                    $newFirma = $editForm['firma']->getData();
                    $newFirma->move($fullDirArchivo, $newFirma->getClientOriginalName());
                    $almacen_cert = file_get_contents($fullDirArchivo . "/" . $newFirma->getClientOriginalName());
                    if (openssl_pkcs12_read($almacen_cert, $info_cert, $editForm['passFirma']->getData())) 
		            {
                        $entity->setDirFirma($fullDirArchivo . "/" . $newFirma->getClientOriginalName());
                        $em->persist($entity);
                        $em->flush();
                        return $this->redirect($this->generateUrl('emisor_show', array('id' => $id)));
					}
					else
					{
                        echo '<script>alert("Error : clave invalida para firma");</script>';
                        return array(
                            'entity' => $entity,
                            'edit_form' => $editForm->createView(),
                            'delete_form' => $deleteForm->createView(),
                        );
					}
				}
				else
				{
                    echo '<script>alert("Error : archivo debe ser p12 o pfx");</script>';
                    return array(
                        'entity' => $entity,
                        'edit_form' => $editForm->createView(),
                        'delete_form' => $deleteForm->createView(),
                    );
				}
            }   
            $em->persist($entity);
            $em->flush();
            return $this->redirect($this->generateUrl('emisor_show', array('id' => $id)));
            
        }

        
    }

    /**
     * Deletes a Emisor entity.
     * @Secure(roles="ROLE_ADMIN")
     * @Route("/{id}", name="emisor_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('FactelBundle:Emisor')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Emisor entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('emisor'));
    }

    /**
     * Creates a form to delete a Emisor entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder(null, array('attr' => array('id' => 'delete')))
                        ->setAction($this->generateUrl('emisor_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->getForm()
        ;
    }

}
