<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * ClienteRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class UserRepository extends EntityRepository {

    public function findUser() {

        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("user, rol, emisor")
                ->from("FactelBundle:User", "user")
                ->join("user.emisor", "emisor")
                ->join("user.rol", 'rol');

        return $qb->getQuery()->getResult();
    }
    
    public function findUserNoAdminEmisor($emisorId) {

        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("user, rol")
                ->from("FactelBundle:User", "user")
                ->join("user.emisor", "emisor")
                ->join("user.rol", 'rol')
                ->where('emisor.id = :emisorId')
                ->andWhere('rol.name != :roleName')
                ->setParameter('emisorId', $emisorId)
                ->setParameter("roleName", "ROLE_ADMIN");

        return $qb->getQuery()->getResult();
    }

    public function findEmisorId($userId){

        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("emisor.id")
                ->from("FactelBundle:User", "user")
                ->join("user.emisor", "emisor")
                ->where('user.id = :userId')
                ->setParameter('userId', $userId);
        return $qb->getQuery()->getSingleScalarResult();
        
    }


    public function findByUserName($userId) {

        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
         $qb->select("user,emisor")
                ->from("FactelBundle:User", "user")
                ->join("user.emisor", "emisor")
                ->where('user.id = :userId')
                ->setParameter('userId', $userId);
        return $qb->getQuery()->getResult();
    }
}
