<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * LiquidacionCompra
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class LiquidacionCompraRepository extends EntityRepository {

    public function findLiquidacionById($id) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("liquidacion, emisor, establecimiento, ptoEmision, liquidacionesCompraHasProducto, producto, impuestos, cliente")
                ->from("FactelBundle:LiquidacionCompra", "liquidacion")
                ->join("liquidacion.emisor", "emisor")
                ->join("liquidacion.establecimiento", "establecimiento")
                ->join("liquidacion.cliente", "cliente")
                ->join("liquidacion.ptoEmision", "ptoEmision")
                ->join("liquidacion.liquidacionesCompraHasProducto", "liquidacionesCompraHasProducto")
                ->join("liquidacionesCompraHasProducto.producto", "producto")
                ->join("liquidacionesCompraHasProducto.impuestos", "impuestos")
                ->where('liquidacion.id = :id')
                ->setParameter('id', $id);

        return $qb->getQuery()->getOneOrNullResult();
    }


    public function cantidadLiquidaciones($idPtoEmision, $idEmisor, $soloAutorizadas = false) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(liquidacion.id)")
                ->from("FactelBundle:LiquidacionCompra", "liquidacion");
        if ($idEmisor == null) {
            $qb->join("liquidacion.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("liquidacion.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
        if ($soloAutorizadas) {
            $qb->andWhere('liquidacion.estado = :estadoLiquidacion');
            $qb->setParameter("estadoLiquidacion", "AUTORIZADO");
        }
        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }


    public function cantidadLiquidacionesC($idPtoEmision, $idEmisor, $fechaInicial,$fechaFinal,$soloAutorizadas = false) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(liquidacion.id)")
                ->from("FactelBundle:LiquidacionCompra", "liquidacion");
        if ($idEmisor == null) {
            $qb->join("liquidacion.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("liquidacion.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
      
            $qb->andWhere('liquidacion.estado = :estadoLiquidacion');
            $qb->setParameter("estadoLiquidacion", "AUTORIZADO");
        
        $qb->andWhere("liquidacion.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
        ->setParameter('fechaInicial', $fechaInicial)
        ->setParameter('fechaFinal', $fechaFinal);
        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }

    public function cantidadLiquidacionesEstados($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("liquidacion.estado,COUNT(liquidacion.estado) as cantidad")
                ->from("FactelBundle:LiquidacionCompra", "liquidacion");
        if ($idEmisor == null) {
            $qb->join("liquidacion.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("liquidacion.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

        $qb->groupBy("liquidacion.estado");
        return $qb->getQuery()->getResult();
    }

  
    public function findLiquidaciones($search, $start, $limit, $idPtoEmision, $idEmisor, $soloAutorizadas = false) {
        $datos = explode("&", $search);
        $fechaInicial = "";
        $fechaFinal = "";
        if (count($datos) == 3) {
            $search = $datos[2];
            $fechaInicial = $datos[0];
            $fechaFinal = $datos[1];
        }

        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("liquidacion, estab, ptoEmision, cliente")
                ->from("FactelBundle:LiquidacionCompra", "liquidacion")
                ->join("liquidacion.emisor", "emisor")
                ->join("liquidacion.establecimiento", "estab")
                ->join("liquidacion.ptoEmision", "ptoEmision")
                ->join("liquidacion.cliente", "cliente");
        $qb->setMaxResults($limit);
        $qb->setFirstResult($start);
        if ($search != "") {
            $qb->where(
                            $qb->expr()->like('liquidacion.estado', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('liquidacion.claveAcceso', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('liquidacion.secuencial', $qb->expr()->literal('%' . $search . '%'))
                    )
                    
                    ->orWhere(
                            $qb->expr()->like('cliente.nombre', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('liquidacion.numeroAutorizacion', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.identificacion', $qb->expr()->literal('%' . $search . '%'))
            );
        }

        if ($idEmisor == null) {
            $qb->andWhere('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->andWhere('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
        if ($fechaInicial != "" && $fechaFinal) {
            $qb->andWhere("liquidacion.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        }
        if ($soloAutorizadas) {
            $qb->andWhere('liquidacion.estado = :estadoLiquidacion');
            $qb->setParameter("estadoLiquidacion", "AUTORIZADO");
        }
        $qb->orderBy("liquidacion.secuencial", "DESC");
        return $qb->getQuery()->getResult();
    }

}
