<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * EstablecimientoRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class EstablecimientoRepository extends EntityRepository {

    public function findEstablecimientos() {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("estab, emisor.razonSocial, estab.nombre")
                ->from("FactelBundle:Establecimiento", "estab")
                ->join('estab.emisor', 'emisor');

        return $qb->getQuery()->getResult();
    }
    
    public function findEstablecimientosEmisor($emisorId) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("estab, emisor.razonSocial")
                ->from("FactelBundle:Establecimiento", "estab")
                ->join('estab.emisor', 'emisor')
                ->where('emisor.id = :emisorId')
                ->setParameter('emisorId', $emisorId);

        return $qb->getQuery()->getResult();
    }

}
