<?php

namespace FactelBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use FactelBundle\Entity\ats;
use FactelBundle\Entity\Compra;
use factura\Entity\factura;
use FactelBundle\Form\ClienteType;
use JMS\SecurityExtraBundle\Annotation\Secure;
use Symfony\Component\HttpFoundation\Response;

require_once 'reader.php';

/**
 * ats controller.
 *
 * @Route("/ats")
 */
class atsController extends Controller {

    /**
     * Lists all ats entities.
     *
     * @Route("/", name="ats")
     * @Secure(roles="ROLE_EMISOR")
     * @Method("GET")
     * @Template()
     */
    public function indexAction() {
       return array();
    }
    

    /**
     * Lists all ats entities.
     *
     * @Route("/ats", name="all_ats")
     * @Secure(roles="ROLE_EMISOR")
     * @Method("GET")
     */
    public function atsAction() {
        if (isset($_GET['sEcho'])) {
            $sEcho = $_GET['sEcho'];
        }
        if (isset($_GET['iDisplayStart'])) {
            $iDisplayStart = intval($_GET['iDisplayStart']);
        }
        if (isset($_GET['iDisplayLength'])) {
            $iDisplayLength = intval($_GET['iDisplayLength']);
        }
        if (isset($_GET['sSearch'])) {
            $sSearch = $_GET['sSearch'];
        }
        $em = $this->getDoctrine()->getManager();
        $emisorId = $this->get("security.context")->gettoken()->getuser()->getEmisor()->getId();
        $count = $em->getRepository('FactelBundle:ats')->cantidadats($emisorId);
        $entities = $em->getRepository('FactelBundle:ats')->findats($sSearch, $iDisplayStart, $iDisplayLength, $emisorId);
        $totalDisplayRecords = $count;

        if ($sSearch != "") {
            $totalDisplayRecords = count($entities);
        }
        $atsArray = array();
        $i = 0;
        foreach ($entities as $entity) {
            $atsArray[$i] = [$entity->getId(), $entity->getTipoIdentificacion(), $entity->getIdentificacion(), $entity->getNombre(), $entity->getCelular(), $entity->getCorreoElectronico(), $entity->getDireccion()];
            $i++;
        }

        $arr = array(
            "iTotalRecords" => (int) $count,
            "iTotalDisplayRecords" => (int) $totalDisplayRecords,
            'aaData' => $atsArray
        );

        $post_data = json_encode($arr);

        return new Response($post_data, 200, array('Content-Type' => 'application/json'));
    }

  

    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('FactelBundle:ats')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find ats entity.');
        }
        if (!$this->get("security.context")->isGranted("ROLE_ADMIN")) {
            $emisorId = $this->get("security.context")->gettoken()->getuser()->getEmisor()->getId();
            if ($emisorId != $entity->getEmisor()->getId()) {
                $this->get('session')->getFlashBag()->add(
                        'notice', "Solo puede ver los ats de su empresa"
                );
                return $this->redirect($this->generateUrl('home', array()));
            }
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity' => $entity,
            'delete_form' => $deleteForm->createView(),
        );
    }

  
    }


/*  index
atsaction
mostrar 
buscar por fecha
imprimir por excel
*/