<?php

namespace FactelBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class EmisorType extends AbstractType {

    private $securityContext;

    public function __construct($securityContext) {
        $this->securityContext = $securityContext;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
    
    	if ($this->securityContext->isGranted("ROLE_ADMIN") || $this->securityContext->isGranted("ROLE_EMISOR_ADMIN")) {
            		$builder->add('activo', 'checkbox', array(
                    	'required' => false
        			))
                    ->add('artesano')
                          ->add('logo', 'file', array(
                        'data_class' => 'Symfony\Component\HttpFoundation\File\File',
                        'property_path' => 'logo',
                        'required' => false
                    ))
                    ->add('firma', 'file', array(
                        'data_class' => 'Symfony\Component\HttpFoundation\File\File',
                        'property_path' => 'firma',
                        'required' => false
                    ));

            /*
            if ($this->securityContext->isGranted("ROLE_ADMIN")) {
                $builder->add('activo', 'checkbox', array(
                    'required' => false,
                ))->add('dirDocAutorizados', 'text', array(
                    'label' => 'Ruta Autorizados'
                ));
            }
            */
        }
    
 
        $builder
                ->add('ruc', 'text',array(
                    'label' => 'RUC',
                    'attr' => array('maxlength' => '13','oninput' => 'this.value = this.value.replace(/[^0-9.]/g, ""); this.value = this.value.replace(/(\..*)\./g, "$1");')
                ))
                ->add('razonSocial', 'text', array(
                    'label' => 'Razón Social',
                    'attr' => array('onkeyup' => 'javascript:this.value=this.value.toUpperCase();')
                ))
                ->add('nombreComercial', 'text', array(
                    'label' => 'Nombre Comercial',
                    'attr' => array('onkeyup' => 'javascript:this.value=this.value.toUpperCase();'),
                    'required' => false,
                ))
                ->add('direccionMatriz', 'text', array(
                    'label' => 'Dirección Matriz',
                    'attr' => array('onkeyup' => 'javascript:this.value=this.value.toUpperCase();')
                ))
                ->add('ambiente', 'choice', array(
                    'choices' => array(
                        '1' => 'Pruebas',
                        '2' => 'Producción'
                    ),
                    'required' => true,
                    'placeholder' => 'Seleccionar el Ambiente',
                ))
                ->add('tipoEmision', 'choice', array(
                    'choices' => array(
                        '1' => 'Normal',
                        '2' => 'Indisponibilidad SRI',
                    ),
                    'required' => true,
                    'placeholder' => 'Seleccionar el Tipo de Emisión',
                ))
                ->add('contribuyenteEspecial', 'text', array(
                    'label' => 'Contribuyente Especial',
                    'required' => false,
                ))
                ->add('obligadoContabilidad', 'choice', array(
                    'choices' => array(
                        'SI' => 'SI',
                        'NO' => 'NO'
                    ),
                    'label' => 'Obligado Contabilidad',
                    'required' => true,
                    'placeholder' => 'Obligado Contabilidad?',
                ))
                ->add('passFirma', 'repeated', array(
                    'type' => 'text',
                    'invalid_message' => 'Las dos contraseñas deben coincidir',
                    'first_options' => array('label' => 'Contraseña Firma'),
                    'second_options' => array('label' => 'Re-Contraseña'),
                    'required' => false))
                ->add('servidorCorreo', 'text', array(
                    'label' => 'Servidor Correo'
                ))
                ->add('correoRemitente', 'email', array(
                    'label' => 'Correo Remitente'
                ))
                ->add('passCorreo', 'repeated', array(
                    'type' => 'text',
                    'invalid_message' => 'Las dos contraseñas deben coincidir',
                    'first_options' => array('label' => 'Contraseña Correo'),
                    'second_options' => array('label' => 'Re-Contraseña'),
                    'required' => false))
                ->add('puerto', 'text', array(
                    'label' => 'Puerto'
                ))
                ->add('tipoEmpresa', 'choice', array(
                    'choices' => array(
                        'CONTRIBUYENTE RÉGIMEN RIMPE' => 'CONTRIBUYENTE RÉGIMEN RIMPE',
                        'CONTRIBUYENTE RÉGIMEN RIMPE (NEGOCIOS POPULARES)' => 'CONTRIBUYENTE RÉGIMEN RIMPE (NEGOCIOS POPULARES)',
                        'CONTRIBUYENTE RÉGIMEN GENERAL-AGENTE RETENCION' => 'CONTRIBUYENTE RÉGIMEN GENERAL-AGENTE RETENCION',
                        'CONTRIBUYENTE RÉGIMEN RIMPE-AGENTE RETENCION' => 'CONTRIBUYENTE RÉGIMEN RIMPE-AGENTE RETENCION',
                        'CONTRIBUYENTE RÉGIMEN GENERAL' => 'CONTRIBUYENTE RÉGIMEN GENERAL',
                      
                    ),
                    'label' => 'Tipo Empresa',
                    'required' => true,
                    'placeholder' => 'Tipo Empresa',
                ))
                ->add('calificacionArtesanal',null, array(
                    'label'=>'Calificacion Artesanal',
                    'label_attr' => array('id' => 'calificacionArtesanal_label')
                ));;
		
        
		
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'FactelBundle\Entity\Emisor'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'factelbundle_emisor';
    }

}
