<?php

namespace FactelBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * Compra
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CompraRepository extends EntityRepository {

    public function findCompraById($id) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("Compra, emisor, establecimiento, ptoEmision, liquidacionesCompraHasProducto, producto , cliente")
                ->from("FactelBundle:Compra", "Compra")
                ->join("Compra.emisor", "emisor")
                ->join("Compra.establecimiento", "establecimiento")
                ->join("Compra.cliente", "cliente")
                ->join("Compra.ptoEmision", "ptoEmision")
                ->join("Compra.liquidacionCompraHasProducto", "liquidacionesCompraHasProducto")
                ->join("liquidacionesCompraHasProducto.producto", "producto")
               
                ->where('Compra.id = :id')
                ->setParameter('id', $id);

        return $qb->getQuery()->getOneOrNullResult();
    }


    public function cantidadCompra($idPtoEmision, $idEmisor, $soloAutorizadas = false) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("COUNT(Compra.id)")
                ->from("FactelBundle:Compra", "Compra");
        if ($idEmisor == null) {
            $qb->join("Compra.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("Compra.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
        if ($soloAutorizadas) {
            $qb->andWhere('Compra.estado = :estadoCompra');
            $qb->setParameter("estadoCompra", "AUTORIZADO");
        }
        try {
            return $qb->getQuery()->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return 0;
        }
    }

    public function cantidadCompraEstados($idPtoEmision, $idEmisor) {
        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("Compra.estado,COUNT(Compra.estado) as cantidad")
                ->from("FactelBundle:Compra", "Compra");
        if ($idEmisor == null) {
            $qb->join("Compra.ptoEmision", "ptoEmision");
            $qb->where('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->join("Compra.emisor", "emisor");
            $qb->where('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }

        $qb->groupBy("Compra.estado");
        return $qb->getQuery()->getResult();
    }

  
    public function findCompra($search, $start, $limit, $idPtoEmision, $idEmisor, $soloAutorizadas = false) {
        $datos = explode("&", $search);
        $fechaInicial = "";
        $fechaFinal = "";
        if (count($datos) == 3) {
            $search = $datos[2];
            $fechaInicial = $datos[0];
            $fechaFinal = $datos[1];
        }

        $em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();
        $qb->select("Compra, estab, ptoEmision, cliente")
                ->from("FactelBundle:Compra", "Compra")
                ->join("Compra.emisor", "emisor")
                ->join("Compra.establecimiento", "estab")
                ->join("Compra.ptoEmision", "ptoEmision")
                ->join("Compra.cliente", "cliente");
        $qb->setMaxResults($limit);
        $qb->setFirstResult($start);
        if ($search != "") {
            $qb->where(
                            $qb->expr()->like('Compra.estado', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('Compra.claveAcceso', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('Compra.secuencial', $qb->expr()->literal('%' . $search . '%'))
                    )
                    
                    ->orWhere(
                            $qb->expr()->like('cliente.nombre', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('Compra.numeroAutorizacion', $qb->expr()->literal('%' . $search . '%'))
                    )
                    ->orWhere(
                            $qb->expr()->like('cliente.identificacion', $qb->expr()->literal('%' . $search . '%'))
            );
        }

        if ($idEmisor == null) {
            $qb->andWhere('ptoEmision.id = :idPtoEmision');
            $qb->setParameter("idPtoEmision", $idPtoEmision);
        } else {
            $qb->andWhere('emisor.id = :idEmisor');
            $qb->setParameter("idEmisor", $idEmisor);
        }
        if ($fechaInicial != "" && $fechaFinal) {
            $qb->andWhere("Compra.fechaEmision BETWEEN :fechaInicial AND :fechaFinal")
                    ->setParameter('fechaInicial', $fechaInicial)
                    ->setParameter('fechaFinal', $fechaFinal);
        }
        if ($soloAutorizadas) {
            $qb->andWhere('Compra.estado = :estadoCompra');
            $qb->setParameter("estadoCompra", "AUTORIZADO");
        }
        $qb->orderBy("Compra.secuencial", "DESC");
        return $qb->getQuery()->getResult();
    }

}
